/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1997 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUSuites.cpp
//
//	Description:
//		Utility routines to acquire and release suites for your plug in
//
//	Version history:
//		Version 1.0.0	6/29/2000	Created for Photoshop 6.0.
//			Written by Thomas Ruark.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#include "PIUSuites.h"



//-------------------------------------------------------------------------------
//
//	PIUSuitesAcquire
//
// Acquire all the suites in the given list
//
//-------------------------------------------------------------------------------
SPErr PIUSuitesAcquire(SPBasicSuite* sSPBasic, 
					   _AcquireList* suitesToAcquire, 
					   int16 numSuites)
{
	int16	i;
	SPErr	err = noErr;
	
	for (i = 0; i < numSuites; i++)
	{
		*suitesToAcquire[i].suitePtr = NULL;
	}
	
	if (sSPBasic != NULL)
	{
		for (i = 0; i < numSuites && err == noErr; i++)
		{
			err = sSPBasic->AcquireSuite(suitesToAcquire[i].name, 
										 suitesToAcquire[i].version,
										 suitesToAcquire[i].suitePtr);
			if (err)
				err = errPlugInHostInsufficient;
		}
	}
	else
	{
		err = errPlugInHostInsufficient;
	}

	return err;
}



//-------------------------------------------------------------------------------
//
//	PIUSuitesAcquire
//
// Release all the suites in the given list
//
//-------------------------------------------------------------------------------
void PIUSuitesRelease(SPBasicSuite* sSPBasic, 
				      _AcquireList *suitesToRelease, 
					  int16 numSuites)
{
	if (sSPBasic == NULL)
		return;

	for (int16 i = 0; i < numSuites; i++)
	{
		if (*suitesToRelease[i].suitePtr != NULL)
		{
			sSPBasic->ReleaseSuite(suitesToRelease[i].name, 
								   suitesToRelease[i].version);
			*suitesToRelease[i].suitePtr = NULL;
		}
	}
}
// end PIUSuites.cpp